//=============================================================================
// CozDecoWallTVSmall
//=============================================================================
class CozDecoWallTVSmall extends CozDecoration;

var bool bOn;

#exec OBJ LOAD FILE="..\Textures\CoreTexMisc.utx"
#exec OBJ LOAD FILE="..\Sounds\Ambient.uax"
#exec TEXTURE IMPORT NAME=CozTVOff FILE=..\RPGMasterTest\Textures\CozTVOff.bmp GROUP=Skins

function PublicFrob(DeusExPlayer P)
{
	if (!bOn)
	{
		bOn = True;
		LightType = LT_Steady;
		PlaySound(sound'Switch4ClickOn');
		bUnlit = True;
		ScaleGlow = 2.0;
		MultiSkins[0]=Texture'CoreTexMisc.Glass.News_A01';
		AmbientSound=Sound'Ambient.Ambient.TVNewsFemale';
	}
	else
	{
		bOn = False;
		LightType = LT_None;
		PlaySound(sound'Switch4ClickOff');
		bUnlit = False;
		ResetScaleGlow();
		MultiSkins[0]=Texture'RPGMasterTest.Skins.CozTVOff';
		AmbientSound=None;
	}
}

function PrivateFrob(DeusExPlayer P)
{
	if (!bOn)
	{
		bOn = True;
		LightType = LT_Steady;
		PlaySound(sound'Switch4ClickOn');
		bUnlit = True;
		ScaleGlow = 2.0;
		MultiSkins[0]=Texture'CoreTexMisc.Glass.News_A01';
		AmbientSound=Sound'Ambient.Ambient.TVNewsFemale';
	}
	else
	{
		bOn = False;
		LightType = LT_None;
		PlaySound(sound'Switch4ClickOff');
		bUnlit = False;
		ResetScaleGlow();
		MultiSkins[0]=Texture'RPGMasterTest.Skins.CozTVOff';
		AmbientSound=None;
	}
}

function BeginPlay()
{
	local Rotator newRot;

	newRot = Rotation;
	newRot.Roll -= 16384;
	newRot.Yaw += 49152;
	newRot.Pitch -= 32768;
	SetRotation(newRot);
}

defaultproperties
{
     CDI=Class'RPGMasterTest.CozDecoWallTVSmallINV'
     Physics=PHYS_None
     ItemName="Television"
     MultiSkins(0)=Texture'RPGMasterTest.Skins.CozTVOff'
     DrawScale=1.500000
     Mesh=LodMesh'DeusExDeco.Newspaper'
     CollisionRadius=18.000000
     CollisionHeight=18.550000
     LightHue=140
     LightBrightness=96
     LightSaturation=255
     LightRadius=8
     FragType=Class'DeusEx.GlassFragment'
}
